//package globalExamples;

import oracle.express.spl.SPLExecutor;
import java.sql.SQLException;
import oracle.olapi.data.source.DataProvider;
import oracle.express.olapi.data.full.ExpressDataProvider;

/**
 * Complete code for Example 3-6, Executing DML Commands, in Chapter 3,
 * Connecting to a Data Store, in the Oracle OLAP Developer's Guide
 * to the OLAP API.
 *
 * @author Oracle Corporation
 */
public class ExecutingDMLCommands
{
  public ExecutingDMLCommands()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);
    ExpressDataProvider dp = (ExpressDataProvider) context.dp;

    context.println("Example 3-6, Executing DML Commands\n");

    // Get the current connection
    oracle.jdbc.OracleConnection conn = dp.getConnection();
    SPLExecutor dmlExec = new SPLExecutor(conn);

    // Initialize the SPLExecutor.
    try
    {
      dmlExec.initialize();
    }
    catch(SQLException e)
    {
      context.println("Could not initialize the SPLExecutor. " + e);
    }

    try
    {
      // Execute a DML command.
      String returnVal = dmlExec.executeCommand("aw list");
      context.println("The return value of the aw list command is: "
                       + returnVal);

      // Execute another DML command.
      returnVal = dmlExec.executeCommand("cda");
      context.println("The return value of the cda command is: " + returnVal);
    }
    catch (Exception e)
    {
      context.println("Cannot execute the DML command. " + e);
    }
  }
  public static void main(String[] args)
  {
    new ExecutingDMLCommands().run(args);
  }
}
